/* $Header: svn://svn.omnis.net/branches/Studio10.2/Omnis_Master/CrossPlatform/jsworker/omnis_xml2js.js 22469 2019-03-28 15:16:46Z jgissing $ */
// Contains the Omnis JavaScript worker xml2js module implementation
// Copyright (C) OLS Holdings Ltd 2018

/*********************************** Changes History **********************************
Date			Edit				Bug					Description
28-Mar-19	jmg_unmarked						Updated to use relative path for simple modules.
11-Mar-19	jmg_unmarked						Updated some namings to be more explicit.
21-Nov-18	rmm_jsw									OW3 component - JavaScript Worker.
**************************************************************************************/
const parseString = require('xml2js').parseString;
const omnis_calls = require('omnis_calls.js');

// Map of methods that can be called in this module
class methodMapClass {
	xml2js(param, response) {
		let ret = false;
		parseString(param.xml, function (err, result) {
			if (!err) {
				ret = true;
				omnis_calls.sendResponse(result, response);
			}
		});
		return ret;
	}
}

const xml2jsModule = {
	methodMap: new methodMapClass(),

	call: function (method, param, response) {
		return this.methodMap[method](param, response);
	}
};

module.exports = xml2jsModule;
